IF EXISTS (SELECT 1 FROM SYS.VIEWS WHERE NAME = 'V_EST_ARV_MD_F_GRP_PARAM_PRC_FILIAL')
    BEGIN 
	   DROP VIEW V_EST_ARV_MD_F_GRP_PARAM_PRC_FILIAL;
    END
GO

/*

=======================================================================================
'Job.................: 
'Função..............: Relatório 
'Objetivo............: Buscar os parametros de Media F e proximo recalculo.
'Tabelas.............: EST_ARV_MD_F_GRP_PARAM_PRC_FILIAL | EST_ARV_MD_F_GRP_PARAM
'Dt Modificação......: 19/10/2020
'Modificação.........: Foi realizado ajuste no retorno da  FREAV_MEDIAF_ULT_ATU  e PROXIMO_RECALC, para considerar por filial. 
Tag #A001
'=======================================================================================
Tag #A001 - Alteração do codigo  
Tag #I001 - Inclusão de novo codigo 

*/


CREATE VIEW [dbo].[V_EST_ARV_MD_F_GRP_PARAM_PRC_FILIAL]
AS

-- Tag #A001
SELECT     
	EST_ARV_MD_F_GRP_PARAM_PRC_FILIAL.CD_EMP, 
	EST_ARV_MD_F_GRP_PARAM_PRC_FILIAL.CD_FILIAL, 
	EST_ARV_MD_F_GRP_PARAM_PRC_FILIAL.CD_GRP_PARAM, 
	EST_ARV_MD_F_GRP_PARAM.DS_GRP_PARAM, 
    EST_ARV_MD_F_GRP_PARAM.CD_SIGLA, 
	EST_ARV_MD_F_GRP_PARAM.P1, 
	EST_ARV_MD_F_GRP_PARAM.P2, 
    EST_ARV_MD_F_GRP_PARAM.P1_SAZ, 
	EST_ARV_MD_F_GRP_PARAM.P2_SAZ, 
	EST_ARV_MD_F_GRP_PARAM.PPV, 
    EST_ARV_MD_F_GRP_PARAM_EST_ARV_MERC_LINHA.CD_ARV_MERC_LINHA, 
	EST_ARV_MD_F_GRP_PARAM.EMAX, 
    EST_ARV_MD_F_GRP_PARAM.ESEG, 
	EST_ARV_MD_F_GRP_PARAM.FREAV_MEDIAF, 
    EST_ARV_MD_F_GRP_PARAM_PRC_FILIAL.FREAV_MEDIAF_FILIAL_ULT_ATU  as FREAV_MEDIAF_ULT_ATU, 
    EST_ARV_MD_F_GRP_PARAM.DT_ULT_ALT, 
	ISNULL(DATEADD(DAY, EST_ARV_MD_F_GRP_PARAM.FREAV_MEDIAF,EST_ARV_MD_F_GRP_PARAM_PRC_FILIAL.FREAV_MEDIAF_FILIAL_ULT_ATU),GETDATE()) AS PROXIMO_RECALC,
	0 TP_GRUPO_PARAMETRO
FROM         
	EST_ARV_MD_F_GRP_PARAM_PRC_FILIAL INNER JOIN EST_ARV_MD_F_GRP_PARAM ON 
	EST_ARV_MD_F_GRP_PARAM_PRC_FILIAL.CD_EMP = EST_ARV_MD_F_GRP_PARAM.CD_EMP AND 
	EST_ARV_MD_F_GRP_PARAM_PRC_FILIAL.CD_GRP_PARAM = EST_ARV_MD_F_GRP_PARAM.CD_GRP_PARAM 
	INNER JOIN EST_ARV_MD_F_GRP_PARAM_EST_ARV_MERC_LINHA ON 
	EST_ARV_MD_F_GRP_PARAM.CD_EMP = EST_ARV_MD_F_GRP_PARAM_EST_ARV_MERC_LINHA.CD_EMP AND 
	EST_ARV_MD_F_GRP_PARAM.CD_GRP_PARAM = EST_ARV_MD_F_GRP_PARAM_EST_ARV_MERC_LINHA.CD_GRP_PARAM

WHERE ISNULL((SELECT VALOR FROM PRC_EMP_CONFIG WHERE  CD_EMP = 1 AND CD_CHAVE = 'FLAG_USA_NOVO_MODELO_PARAMETROS' ),0) = 0

UNION 
	 
 SELECT     
	B.CD_EMP, 
	B.CD_FILIAL, 
	B.CD_CTR CD_GRP_PARAM, 
	S.DS_GRUPO_CURVA DS_GRP_PARAM, 
    grp.CD_SIGLA, 
	grp.P1, 
	grp.P2, 
    grp.P1_SAZ, 
	grp.P2_SAZ, 
	0 PPV, 
    L.CD_ARV_MERC_LINHA, 
	grp.EMAX, 
    grp.ESEG, 
	C.FREVISAOMEDIAF FREAV_MEDIAF, 
    C.DT_ULT_ALT FREAV_MEDIAF_ULT_ATU, 
	C.DT_ULT_ALT DT_ULT_ALT ,
	 CONVERT(DATE, ISNULL(DATEADD(DAY, C.FREVISAOMEDIAF , C.DT_ULT_ALT),GETDATE()) )PROXIMO_RECALC,
	1 GRUPO_PARAMETRO_NOVO
 
FROM
	EST_PARAM_COMPRAS_GRUPO_CURVA_USO AS A
	JOIN EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL AS B ON A.CD_CTR_COMPRAS_GRUPO=B.CD_CTR
	JOIN EST_PARAM_COMPRAS_GRUPO_CURVA_EST_PROD_CURVA_SIGLA AS C ON	
		A.CD_GRUPO_CURVA=C.CD_GRUPO_CURVA AND  
		A.CD_SIGLA=C.CD_SIGLA 
	JOIN EST_PARAM_COMPRAS_GRUPO_CURVA AS S ON	
		A.CD_GRUPO_CURVA=S.CD_GRUPO_CURVA   
	JOIN EST_PARAM_COMPRAS_GRUPO_CURVA_EST_PROD_CURVA_SIGLA GRP ON 
		A.CD_GRUPO_CURVA=GRP.CD_GRUPO_CURVA AND  
		A.CD_SIGLA		=GRP.CD_SIGLA 
	JOIN EST_PARAM_COMPRAS_GRUPO_EST_ARV_MERC_LINHA L ON 
	B.CD_CTR	=L.CD_CTR AND 
	B.CD_EMP	=L.CD_EMP  AND	
	C.CD_GRUPO_CURVA =L.CD_GRUPO_CURVA 
 where
	EXISTS (SELECT VALOR FROM PRC_EMP_CONFIG
				WHERE  CD_EMP = 1 AND CD_CHAVE = 'FLAG_USA_NOVO_MODELO_PARAMETROS'
						and valor=1)


